public class RegisterScriptMenu
{
    [DeclareAction("OpenProjectFolderInExplorerAction")]
    public void MyFunctionAsAction()
    {
        // Projectpath
        string sProjectpath = PathMap.SubstitutePath("$(PROJECTPATH)");
        sProjectpath = sProjectpath.Substring(0, sProjectpath.LastIndexOf("\\"));
        // Start Explorer with Parameter
        System.Diagnostics.Process.Start("explorer", sProjectpath);
    }
    [DeclareMenu]
    public void MenuFunction()
    {
        uint intIDUntermenue1;                                         // MenuID
        Eplan.EplApi.Gui.Menu oMenu = new Eplan.EplApi.Gui.Menu();
        intIDUntermenue1 = oMenu.AddMainMenu(
            "ePlanus",                                                     // Hauptmenüname
            "Hilfe",                                                       // neben Menüpunkt...
            "< ePlanus.de >",                                              // Menüpunktname
            "ePlanus",                                                     // Action
            "ePlanus.de - Scripting in Eplan ist einfach (toll)",          // Statustext
            1                                                              // Hinter Menüpunkt x
        );
        // Untermenüpunkte
        oMenu.AddMenuItem(
            "Open project path",                                            // Menüpunktname
            "OpenProjectFolderInExplorerAction",                            // Action
            "Projektordner im Windows-Explorer öffnen",                     // Statustext
            intIDUntermenue1,                                               // Menü-ID
            1,                                                              // 1 = Hinter Menüpunkt X
            false,                                                          // Seperator davor
            false                                                           // Seperator dahinter
        );

    }

}